/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.tank;

import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.recipe.cauldron.ICauldronRecipe;
import knightminer.inspirations.recipes.tileentity.TileCauldron;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class CauldronTank
implements IFluidHandler {
    private TileCauldron cauldron;
    private Properties[] properties;

    public CauldronTank(TileCauldron cauldron) {
        this.cauldron = cauldron;
        this.properties = new Properties[]{new Properties(cauldron)};
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.properties;
    }

    private static int getLevels(int amount) {
        if (Config.enableBiggerCauldron) {
            return amount / 250;
        }
        return amount >= 1000 ? 3 : 0;
    }

    private static int getAmount(int levels) {
        if (Config.enableBiggerCauldron) {
            return levels * 250;
        }
        return levels == 3 ? 1000 : 0;
    }

    public int fill(FluidStack stack, boolean doFill) {
        int max;
        if (stack.tag != null) {
            return 0;
        }
        int level = this.cauldron.getFluidLevel();
        if (level == (max = InspirationsRegistry.getCauldronMax())) {
            return 0;
        }
        ICauldronRecipe.CauldronState state = this.cauldron.getState();
        if (level == max || level > 0 && state.getFluid() != stack.getFluid()) {
            return 0;
        }
        int toInsert = Math.min(CauldronTank.getLevels(stack.amount), max - level);
        if (toInsert == 0) {
            return 0;
        }
        if (doFill) {
            this.cauldron.setState(ICauldronRecipe.CauldronState.fluid(stack.getFluid()), false);
            this.cauldron.setFluidLevel(toInsert + level);
        }
        return CauldronTank.getAmount(toInsert);
    }

    public FluidStack drain(FluidStack stack, boolean doDrain) {
        if (stack.tag != null) {
            return null;
        }
        ICauldronRecipe.CauldronState state = this.cauldron.getState();
        if (state.getFluid() != stack.getFluid()) {
            return null;
        }
        return this.drain(stack.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        ICauldronRecipe.CauldronState state = this.cauldron.getState();
        if (state.getFluid() == null) {
            return null;
        }
        int level = this.cauldron.getFluidLevel();
        if (level == 0) {
            return null;
        }
        int toDrain = Math.min(CauldronTank.getLevels(maxDrain), level);
        if (toDrain == 0) {
            return null;
        }
        if (doDrain) {
            this.cauldron.setFluidLevel(level - toDrain);
        }
        return new FluidStack(state.getFluid(), CauldronTank.getAmount(toDrain));
    }

    private static class Properties
    implements IFluidTankProperties {
        private TileCauldron cauldron;

        public Properties(TileCauldron cauldron) {
            this.cauldron = cauldron;
        }

        public FluidStack getContents() {
            Fluid fluid = this.cauldron.getState().getFluid();
            if (fluid == null) {
                return null;
            }
            int amount = this.cauldron.getFluidLevel();
            if (amount == 0) {
                return null;
            }
            return new FluidStack(fluid, CauldronTank.getAmount(amount));
        }

        public int getCapacity() {
            return 1000;
        }

        public boolean canFill() {
            return true;
        }

        public boolean canDrain() {
            return true;
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return fluidStack.tag == null;
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return fluidStack.tag == null;
        }
    }
}

